#include "Level.h"
#include "Input.h"

//	//	//	//
Level* Level::currentLevel = NULL;
EnemyManager* Level::enemyManager = NULL;
ItemManager* Level::itemManager = NULL;			//	Initalize all of our static pointers initially to NULL
MoveablesManager* Level::moveablesManager = NULL;
GameMap* Level::gameMap = NULL;
AudioManager* Level::audioManager = NULL;
//	//	//	//

Level::Level(sf::RenderWindow* hwnd, Input* input)
{
	window = hwnd;
	userInput = input;

	if (!NESFont.loadFromFile("Assets/Font/nes.ttf"))	//If we have an error loading the font
	{
		std::cout << "Error loading NES Font!" << std::endl;	//Output an error to the user
	}

	audioManager->addSound("Assets/Audio/1UP.ogg", "1UP");
	audioManager->addSound("Assets/Audio/Jump.ogg", "Jump");
	audioManager->addSound("Assets/Audio/BlockBreak.ogg", "BlockBreak");
	audioManager->addSound("Assets/Audio/CollectCoin.ogg", "CollectCoin");
	audioManager->addSound("Assets/Audio/Death.ogg", "Death");
	audioManager->addSound("Assets/Audio/FlagMove.ogg", "FlagMove");
	audioManager->addSound("Assets/Audio/GameOver.ogg", "GameOver");
	audioManager->addSound("Assets/Audio/Kick.ogg", "Kick");
	audioManager->addMusic("Assets/Audio/LevelComplete.ogg", "LevelComplete");
	audioManager->addMusic("Assets/Audio/LevelTheme.ogg", "LevelTheme");
	audioManager->addSound("Assets/Audio/LosePowerUp.ogg", "PowerDown");
	audioManager->addSound("Assets/Audio/Pause.ogg", "Pause");
	audioManager->addSound("Assets/Audio/PowerUp.ogg", "PowerUp");
	audioManager->addSound("Assets/Audio/ReleaseItem.ogg", "ReleaseItem");
	audioManager->addSound("Assets/Audio/ScoreBeep.ogg", "ScoreBeep");
	audioManager->addSound("Assets/Audio/Collide.ogg", "Collide");
	audioManager->addSound("Assets/Audio/SquishEnemy.ogg", "Squish");
	audioManager->addMusic("Assets/Audio/Victory.ogg", "Victory");
}

Level::~Level()
{
}

void Level::update(float deltaTime)
{
	if (Level::currentLevel)
	{
		Level::currentLevel->update(deltaTime);	//Update the current level, passing dt
	}

}
void Level::handleInput(float deltaTime)
{
	if (Level::currentLevel)
	{
		Level::currentLevel->handleInput(deltaTime);	//Handle input for the current level, passing dt
	}
}
void Level::render()
{
	beginDraw();

	if (Level::currentLevel)
	{
		Level::currentLevel->render();	//Render for the current level
	}

	endDraw();
}

void Level::beginDraw()
{
	window->clear(sf::Color::Black);
}
void Level::endDraw()
{
	window->display();
}

void Level::setupTextObject(sf::Text* textObj)
{
	textObj->setFont(NESFont);	//Set the font for textObj to the NESFont
	textObj->setCharacterSize(30);	//Set the font size for textObj to 30
	textObj->setFillColor(sf::Color::White);	//Set the foreground colour for the textObj to White
}

std::string Level::updateScoreText()	//updateScoreText returns a correctly formatted score string to be displayed
{
	std::string returnStr = "";	//Initialize the string we're returning
	int length = std::to_string(mario.getScore()).length();	//Get the physical length of the score string

	for (int i = 0; i < 6 - length; i++)
	{
		returnStr += "0";	//We fill the empty spaces with zeroes
	}

	returnStr += std::to_string(mario.getScore());	//We then append the actual score onto the end so it is formatted correctly
	return returnStr;	//Return the formatted string
}

